Rem FindChangeByList.vbs
Rem An InCopy VBScript
Rem
Rem Loads a series of tab-delimited strings from a text file, then performs a series
Rem of find/change operations based on the strings read from the file.
Rem
Rem The data file is tab-delimited, with carriage returns separating records.
Rem
Rem The format of each record in the file is:
Rem findType<tab>findProperties<tab>changeProperties<tab>findChangeOptions<tab>description
Rem 
Rem Where:
Rem <tab> is a tab character
Rem findType is "text", "grep", or "glyph" (this sets the type of find/change operation to use).
Rem findProperties is a properties record (as text) of the find preferences.
Rem changeProperties is a properties record (as text) of the change preferences.
Rem findChangeOptions is a properties record (as text) of the find/change options.
Rem description is a description of the find/change operation
Rem 
Rem Very simple example:
Rem text	{findWhat:"--"}	{changeTo:"^_"}	{includeFootnotes:true, includeMasterPages:true, includeHiddenLayers:true, wholeWord:false}	Find all double dashes and replace with an em dash.
Rem 
Rem More complex example:
Rem text	{findWhat:"^9^9.^9^9"}	{appliedCharacterStyle:"price"}	{include footnotes:true, include master pages:true, include hidden layers:true, whole word:false}	Find $10.00 to $99.99 and apply the character style "price".
Rem 
Rem All InCopy search metacharacters are allowed in the "find what" and "change to" properties.
Rem
main
Function main()
	Set myInCopy = CreateObject("InCopy.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInCopy.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInCopy.Documents.Count > 0 Then
	    If myInCopy.Documents.Item(1).Stories.Count > 0 Then
	        If myInCopy.Selection.Count > 0 Then
	            Select Case TypeName(myInCopy.Selection.Item(1))
	                Case "InsertionPoint", "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text", "Cell", "Table", "Row", "Column"
	                    myDisplayDialog(myInCopy)
	                Case Else:
	                    myFindChangeByList myInCopy, myInCopy.Documents.Item(1)
	            End Select
	     	Else
	            myFindChangeByList myInCopy, myInCopy.Documents.Item(1)
	        End If
	    Else
	        MsgBox ("The current document contains no text. Please open a document containing text and try again.")
	    End If
	Else
	    MsgBox ("No documents are open. Please open a document and try again.")
	End If
End Function
Function myDisplayDialog(myInCopy)
    myObject = "None"
    Set myDialog = myInCopy.Dialogs.Add
    myDialog.Name = "FindChangeByList"
    With myDialog.DialogColumns.Add
        With .DialogRows.Add
            With .DialogColumns.Add
                With .StaticTexts.Add
                    .StaticLabel = "Search Range"
                End With
            End With
            With .DialogColumns.Add
                Set myRangeButtons = .RadiobuttonGroups.Add
                With myRangeButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Document"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Selected Story"
                    End With
                    If myInCopy.Selection.Item(1).Contents <> "" Then
                        With .RadiobuttonControls.Add
                            .StaticLabel = "Selection"
	                        .CheckedState = True
                        End With
                    End If
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        Select Case myRangeButtons.SelectedButton
            Case 0:
                Set myObject = myInCopy.Documents.Item(1)
            Case 1:
                Select Case TypeName(myInCopy.Selection.Item(1))
                    Case "InsertionPoint", "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text"
                        Set myObject = myInCopy.Selection.Item(1).ParentStory
                        myFindChangeByList
                End Select
            Case 2:
                Select Case TypeName(myInCopy.Selection.Item(1))
                    Case "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text"
                        If myInCopy.Selection.Item(1).Contents <> "" Then
                            Set myObject = myInCopy.Selection.Item(1).Texts.Item(1)
						Else
							Set myObject = myInCopy.Selection.Item(1).ParentStory
						End If
                Case Else:
                    Set myObject = Nothing
            End Select
        End Select
		myFindChangeByList myInCopy, myObject
    Else
        myDialog.Destroy
    End If
End Function
Function myFindChangeByList(myInCopy, myObject)
    myFileName = myFindFile(myInCopy, "\FindChangeSupport\FindChangeList.txt")
    If myFileName <> "" Then
        Set myFileSystemObject = CreateObject("Scripting.FileSystemObject")
        Set myFindChangeFile = myFileSystemObject.OpenTextFile(myFileName)
        Rem Loop through the find/change operations.
        Do While Not myFindChangeFile.AtEndOfStream
            myLine = myFindChangeFile.ReadLine
            Rem Ignore empty lines.
            If (Left(myLine, 4) = "text")Or(Left(myLine, 4) = "grep")Or(Left(myLine, 5) = "glyph") Then
                myFindChangeArray = Split(myLine, vbTab)
                Rem The first field in the line is the FindType string.
				myFindType = myFindChangeArray(0)
                Rem The second field in the line is the FindPreferences string.
                myFindPreferences = myFindChangeArray(1)
                Rem The third field in the line is the ChangePreferences string.
                myChangePreferences = myFindChangeArray(2)
                Rem The fourth field in the line can be either "once" or "all".
                Rem If it's "all", keep on searching until no instances of the
                Rem search text are found, if it's "once," search just once.
                myFindChangeOptions = myFindChangeArray(3)
                Select Case myFindType
                	Case "text"
                		myFindText myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions
                	Case "grep"
                		myFindGrep myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions
                	Case "glyph"
                		myFindGlyph myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions
                End Select
            End If
        Loop
        myFindChangeFile.Close
    End If
End Function
Function myFindText(myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions)
	Rem Clear the FindText/ChangeText Preferences before each find/change operation.
	myInCopy.FindTextPreferences = idNothingEnum.idNothing
	myInCopy.ChangeTextPreferences = idNothingEnum.idNothing
	myScript = "app.findTextPreferences.properties = " & myFindPreferences & ";" & vbCr
	myScript = myScript & "app.changeTextPreferences.properties = " & myChangePreferences & ";" & vbCr
	myScript = myScript & "app.findChangeTextOptions.properties = " & myFindChangeOptions & ";" & vbCr
    myInCopy.DoScript myScript, idScriptLanguage.idJavascript
	Set myFoundItems = myObject.ChangeText
	Rem Clear the FindText/ChangeText Preferences after each find/change operation.
	myInCopy.FindTextPreferences = idNothingEnum.idNothing
	myInCopy.ChangeTextPreferences = idNothingEnum.idNothing
End Function
Function myFindGrep(myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions)
	Rem Clear the FindGrep/ChangeGrep Preferences before each find/change operation.
	myInCopy.FindGrepPreferences = idNothingEnum.idNothing
	myInCopy.ChangeGrepPreferences = idNothingEnum.idNothing
	myScript = "app.findGrepPreferences.properties = " & myFindPreferences & ";" & vbCr
	myScript = myScript & "app.changeGrepPreferences.properties = " & myChangePreferences & ";" & vbCr
	myScript = myScript & "app.findChangeGrepOptions.properties = " & myFindChangeOptions & ";" & vbCr
    myInCopy.DoScript myScript, idScriptLanguage.idJavascript
	Set myFoundItems = myObject.ChangeGrep
	Rem Clear the FindGrep/ChangeGrep Preferences after each find/change operation.
	myInCopy.FindGrepPreferences = idNothingEnum.idNothing
	myInCopy.ChangeGrepPreferences = idNothingEnum.idNothing
End Function
Function myFindGlyph(myInCopy, myObject, myFindPreferences, myChangePreferences, myFindChangeOptions)
	Rem Clear the FindGlyph/ChangeGlyph Preferences before each find/change operation.
	myInCopy.FindGlyphPreferences = idNothingEnum.idNothing
	myInCopy.ChangeGlyphPreferences = idNothingEnum.idNothing
	myScript = "app.findGlyphPreferences.properties = " & myFindPreferences & ";" & vbCr
	myScript = myScript & "app.changeGlyphPreferences.properties = " & myChangePreferences & ";" & vbCr
	myScript = myScript & "app.findChangeGlyphOptions.properties = " & myFindChangeOptions & ";" & vbCr
    myInCopy.DoScript myScript, idScriptLanguage.idJavascript
	Set myFoundItems = myObject.ChangeGlyph
	Rem Clear the FindGlyph/ChangeGlyph Preferences after each find/change operation.
	myInCopy.FindGlyphPreferences = idNothingEnum.idNothing
	myInCopy.ChangeGlyphPreferences = idNothingEnum.idNothing
End Function 
Function myFindFile(myInCopy, myRelativePath)
	myFilePath = myInCopy.ActiveScript
	Set myFileSystemObject = CreateObject("Scripting.FileSystemObject")
	myFolderPath = myFileSystemObject.GetFile(myFilePath).ParentFolder.Path
	myFilePath = myFolderPath & myRelativePath
	If myFileSystemObject.FileExists(myFilePath) = True Then
		myFile = myFilePath
	Else
		myFile = myGetFileName(myFolderPath)
	End If
	myFindFile = myFile
End Function
Function myGetFileName(myFolder)
	Set myDialog = CreateObject("UserAccounts.CommonDialog")
	myDialog.Filter = "VBScript files|*.vbs"
	myDialog.InitialDir = myFolder
	myResult = myDialog.ShowOpen	 
	If myResult = 0 Then
	    myFileName = ""
	Else
		myFileName = myDialog.FileName
	End If
	myGetFileName = myFileName
End Function
'' SIG '' Begin signature block
'' SIG '' MIIeVAYJKoZIhvcNAQcCoIIeRTCCHkECAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' c6K0WDlqKCLFKzsGc3BmbN+yGuQsa2jvWy1+RrtSccOg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERgwghEUAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIBet316knbR/
'' SIG '' VnLqUohpbMuqoOR/2ETu6n2n64URAoJ3MDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAE6ehP8Xm
'' SIG '' etkJlLa30zpt4wyJXi03goQqo3IzcHcqkoAJy8NN41sr
'' SIG '' lHHitul35WG1fjUT6hTHl1vfme8HVrmzPxiDGIVmIiDf
'' SIG '' pN76zyb1nS0zGI2ZTxQz6IWPThjJtEyXdgt2pSdSKnlj
'' SIG '' 2Nxq8zRTPb2OacB7S6ViNBrjfX6znwf2jS24OGTCZalS
'' SIG '' Kcy2eruXNesiqgdUZz2pIROaOfL7liFKoKtdSAOiT5ti
'' SIG '' B8r7d0R5OLJR8w/fw357CsEg6ySqbot2W79VWKrxyc/M
'' SIG '' z/JJuEbQFyZYST5IBSOI5MOOaxQEkaAhYo7/KWzR6efS
'' SIG '' yZosK+WtPaWmqHg84arl7CG21KGCDskwgg7FBgorBgEE
'' SIG '' AYI3AwMBMYIOtTCCDrEGCSqGSIb3DQEHAqCCDqIwgg6e
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCC/Crv5o2pd558J1TKhhuGXLQ8x3TFM46RV
'' SIG '' PPF27hO1WwIRANvhVdqo8r/omK5etrB2UQwYDzIwMjAx
'' SIG '' MDA0MDAyMjI1WqCCC7swggaCMIIFaqADAgECAhAEzT+F
'' SIG '' aK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAx
'' SIG '' MDE3MDAwMDAwWjBMMQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVT
'' SIG '' VEFNUC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZI
'' SIG '' hvcNAQEBBQADggEPADCCAQoCggEBAOlkNZz6qZhlZBvk
'' SIG '' F9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
'' SIG '' CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xF
'' SIG '' fpRtrAMBmTxiPn56/UWXMbT6t9lCPqdVm99aT1gCqDJp
'' SIG '' IhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKhFKX4
'' SIG '' +uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxO
'' SIG '' zcbVsmVZIeB8LBKNcA6Pisrg09ezOXdQ0EIsLnrOnGd6
'' SIG '' OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8fcMbuQhZT
'' SIG '' NkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1Ud
'' SIG '' DwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
'' SIG '' /wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0gBIIBtjCCAbIw
'' SIG '' ggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxo
'' SIG '' dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYI
'' SIG '' KwYBBQUHAgIwggFWHoIBUgBBAG4AeQAgAHUAcwBlACAA
'' SIG '' bwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBh
'' SIG '' AHQAZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEA
'' SIG '' YwBjAGUAcAB0AGEAbgBjAGUAIABvAGYAIAB0AGgAZQAg
'' SIG '' AEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
'' SIG '' YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQ
'' SIG '' AGEAcgB0AHkAIABBAGcAcgBlAGUAbQBlAG4AdAAgAHcA
'' SIG '' aABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIAaQBs
'' SIG '' AGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8A
'' SIG '' cgBwAG8AcgBhAHQAZQBkACAAaABlAHIAZQBpAG4AIABi
'' SIG '' AHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsGCWCGSAGG
'' SIG '' /WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAdBgNVHQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTs
'' SIG '' nsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMu
'' SIG '' ZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmww
'' SIG '' MqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9z
'' SIG '' aGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5
'' SIG '' MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3Vy
'' SIG '' ZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
'' SIG '' AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3Y
'' SIG '' kqHmRhxKL256PGNuNxejGr9YI7JDnJSDTjkJsCzox+Hi
'' SIG '' zO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/BjdEh
'' SIG '' jOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iC
'' SIG '' gy1tE0Kug8EQTqQk9Eec3g8icndcf0/pOZgrV5JE1+9u
'' SIG '' k9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X/AqfI157
'' SIG '' 9JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18z
'' SIG '' MGBV9fxrMKyh7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm0
'' SIG '' 9zCCBTEwggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUw
'' SIG '' DQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
'' SIG '' QXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
'' SIG '' MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
'' SIG '' cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBD
'' SIG '' QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
'' SIG '' AL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB90Pl9
'' SIG '' TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcu
'' SIG '' HjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/
'' SIG '' Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXciaC1TjqAlx
'' SIG '' a+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287Dxg
'' SIG '' aqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn
'' SIG '' 5HU+upgPhH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN
'' SIG '' 7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOC
'' SIG '' Ac4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd
'' SIG '' 823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
'' SIG '' BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
'' SIG '' Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
'' SIG '' cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6
'' SIG '' oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0Rp
'' SIG '' Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0
'' SIG '' aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAESTBHMDgG
'' SIG '' CmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d
'' SIG '' 2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysf
'' SIG '' DCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLo
'' SIG '' XoIlHsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9I
'' SIG '' EBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
'' SIG '' 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
'' SIG '' jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLE
'' SIG '' frvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
'' SIG '' Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQsw
'' SIG '' CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
'' SIG '' MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
'' SIG '' VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGlt
'' SIG '' ZXN0YW1waW5nIENBAhAEzT+FaK52xhuw/nFgzKdtMA0G
'' SIG '' CWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJAzENBgsq
'' SIG '' hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAxMDA0
'' SIG '' MDAyMjI1WjArBgsqhkiG9w0BCRACDDEcMBowGDAWBBQD
'' SIG '' Jb1QXtqWMC3CL0+gHkwovig0xTAvBgkqhkiG9w0BCQQx
'' SIG '' IgQg+L0xFW3t7gw+175uU2qwaOqz3mFzlvNpw673YdG/
'' SIG '' IowwDQYJKoZIhvcNAQEBBQAEggEAaFIyLydYch/CEj+s
'' SIG '' 8+VF+6Bu22i7XcD3i/m7iDk4Z7GUF879nOiWnKdMGWZ2
'' SIG '' gkL9jXM7/NQQiob/Yi4LFbe5xn4DAv0MOVDXRLSKRllV
'' SIG '' QR38/1mm8THgoDkQEpBkF9OR7hTrEHOki2mFZCm5mqN8
'' SIG '' aEsu+HG2x5qAkO/YsGfASaeV9BcPI5Ze4Mtf7nVvd+C8
'' SIG '' TLUv+bzpm6O9VqDxnXFVujrYPmMgNaB3jF0EcXK1++2u
'' SIG '' SUBpBfI9jsPVd6OFwSrJzWuD2IJ9aNmpk8OZ/JKM9uvC
'' SIG '' Sf7kaIoh+1dWIv0Z54el0Imr99VCedLzGdDXsCaJqsPq
'' SIG '' 7lm531G+rh9Icf6ytw==
'' SIG '' End signature block
